from flask import Flask, render_template
import time

app = Flask(__name__)


def proses():
    for index in range(10):
        print(index)
        time.sleep(0.5)


def read_data():
    csv = []
    with open("data.csv", "r") as reader:
        data = reader.read()
    for line in data.split("\n"):
        line = line.split(",")
        if len(line) == 5:
            row = {
                "nama": line[0],
                "npm": line[1],
                "prodi": line[2],
                "jenis_kelamin": line[3],
                "hp": line[4]
            }
            csv.append(row)
    return csv[1:]

    
@app.route('/')
def index():
    context_data = {
        "data_mahasiswa": read_data()
    }
    return render_template('index.html', **context_data)


@app.route('/detail/<npm>')
def detail(npm):
    # Waktu mulai
    start_time = time.time()
    data = read_data()

    for index in data:
        if index.get('npm') == npm:
            data = index

    # Waktu akhir
    end_time = time.time()

    # Durasi eksekusi
    execution_time = end_time - start_time

    context_data = {
        "data_mahasiswa": data,
        "execution_time": float(execution_time),
    }
    return render_template('detail.html', **context_data)

if __name__ == '__main__':
    app.run(debug = True)
