import tkinter as tk
from tkinter import ttk
import csv

class MahasiswaApp:
    def __init__(self, root):
        self.root = root
        self.root.title("Aplikasi Mahasiswa")
        
        # Inisialisasi Variabel Pencarian
        self.search_var = tk.StringVar()

        # Buat tabel untuk menampilkan data
        self.tree = ttk.Treeview(self.root, columns=('Nama', 'NPM', 'Program Studi', 'Jenis Kelamin', 'Nomor Handphone'))
        self.tree.heading('#0', text='No.')
        self.tree.heading('Nama', text='Nama')
        self.tree.heading('NPM', text='NPM')
        self.tree.heading('Program Studi', text='Program Studi')
        self.tree.heading('Jenis Kelamin', text='Jenis Kelamin')
        self.tree.heading('Nomor Handphone', text='Nomor Handphone')
        self.tree.pack(padx=10, pady=10)

        # Entry untuk pencarian
        search_entry = ttk.Entry(self.root, textvariable=self.search_var, width=20)
        search_entry.pack(pady=10)
        
        # Tombol Pencarian
        search_button = ttk.Button(self.root, text='Cari', command=self.search_data)
        search_button.pack(pady=5)

        # Baca data dari file CSV dan tampilkan dalam tabel
        self.load_data()

        # Menyesuaikan ukuran window
        self.root.geometry("600x400")

    def load_data(self):
        try:
            with open('data.csv', 'r', newline='', encoding='utf-8') as file:
                reader = csv.DictReader(file)
                for i, row in enumerate(reader, start=1):
                    self.tree.insert('', 'end', text=str(i), values=(row['Nama'], row['NPM'], row['Program Studi'], row['Jenis Kelamin'], row['Nomor Handphone']))
        except FileNotFoundError:
            print("File data.csv tidak ditemukan.")

    def search_data(self):
        # Hapus data yang ada di tabel
        for item in self.tree.get_children():
            self.tree.delete(item)

        # Baca data dari file CSV dan tampilkan dalam tabel
        try:
            with open('data.csv', 'r', newline='', encoding='utf-8') as file:
                reader = csv.DictReader(file)
                for i, row in enumerate(reader, start=1):
                    # Filter data sesuai dengan kriteria pencarian
                    if self.search_var.get().lower() in row['Nama'].lower() or self.search_var.get().lower() in row['NPM'].lower():
                        self.tree.insert('', 'end', text=str(i), values=(row['Nama'], row['NPM'], row['Program Studi'], row['Jenis Kelamin'], row['Nomor Handphone']))
        except FileNotFoundError:
            print("File data.csv tidak ditemukan.")

if __name__ == "__main__":
    root = tk.Tk()
    app = MahasiswaApp(root)
    root.mainloop()
